<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../classi/GeneratoreUrl.php";
    include "../classi/PannelloLaterale.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
    session_start();
    
    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $impostazioni        = recuperaImpostazioni($geecomDb);
    $datiProdottoGeecom  = $geecomDb->leggiSingolaRiga("geec_prodotti", 1) ;
    $percorsoGeecomAdmin = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
    
    $pannello  = new Pannellolaterale($geecomDb, filter_input(INPUT_POST, "nomePannello",FILTER_SANITIZE_STRING));
   
    switch ($operazione) {
        case 'aggiungiComponente':
            $pannello ->aggiungiComponente(filter_input(INPUT_POST, "idComponente",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "nomeDaMostrare",FILTER_SANITIZE_ADD_SLASHES));
            echo "ok";
            break;
        case 'spostaElemento':
            $pannello ->spostaComponente(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'modificaElemento':
            $nomePannello   = filter_input(INPUT_POST,"nomePannello",FILTER_SANITIZE_STRING);
            $idComponente   = filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT);
            $idElemento     = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_NUMBER_INT);
            $nomeDaMostrare = filter_input(INPUT_POST,"nomeDaMostrare",FILTER_SANITIZE_ADD_SLASHES);
            $testo          = filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES);
            $pannello->modificaComponente($idComponente,$idElemento, $nomeDaMostrare, $testo);
            if($nomePannello=="destra"){         
                header("Location: {$percorsoGeecomAdmin}/impostazioni.php?status=231");
            }
            else {
                header("Location: {$percorsoGeecomAdmin}/impostazioni.php?status=230");
            }
            break;
        case 'eliminaComponente':
            $pannello ->eliminaComponente(filter_input(INPUT_POST, "idComponente",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'stampaComponentiPannello':
            $pannello ->stampaElencoComponenti();
            break;
    }
